// var script = document.createElement('script');
// script.type = 'text/javascript';
// script.src = "https://unpkg.com/tone@next/build/Tone.js";
// document.head.appendChild(script);

play_chord = function (chord_dict) {
    // Generate a chord, the number of notes involved is specified by the list of intervals
    // The input is provided by a dictionary of the following form
    // chord_dict{
    //   "f0": float // bass tone frequency in midi,
    //   "intervals": [int1,int2,int3,...] // list of intervals from bass tone in midi
    //   "complex": bool // adds a stack of decaying harmonics on top of the fundamentals to generate complex tones, defaults to true
    //   "NH": int // number of harmonics to include in the complex tone, only relevant if complex = true, defaults to 10
    //   "attack": float // time to max amplitude in seconds, defaults to 0.2sec
    //   "decay": float // decay time from max amplitude to sustain, defaults to 0.1sec
    //   "sustain": float // sustain time, defaults to 0.01sec
    //   "duration": float // duration in seconds over which the chord is released, defaults to 1sec
    // }
  
    var reg = 0.1
    var chord = {...chord_dict}
    var intervals = [0].concat(chord["intervals"])
    var N = intervals.length
    var default_dict = {
      "attack": 0.2,
      "decay": 0.1,
      "sustain_amp": 0.8,
      "duration": 1,
      "complex": true,
      "NH": 10
    }
  
    for (key in default_dict) {
      if (!(key in chord)){
        chord[key] = default_dict[key]
      }
    }
  
    var ampEnv = new Tone.AmplitudeEnvelope({
          "attack": chord["attack"],
          "decay": chord["decay"],
          "sustain": chord["sustain_amp"],
          "release": chord["duration"],
          "attackCurve" : "linear",
          "releaseCurve" : "exponential"
        }).toMaster();
        
    if (chord["complex"]) {
        osc_dict = {
            "partials": util_complex(chord["NH"]),
            "type": "custom"
        }
    } else {
        osc_dict = {}
    }

    for (i=0;i<N;i++){
        spec_dict = {...osc_dict}
        spec_dict = Object.assign({},spec_dict,{
            "frequency": util_midi2freq(chord["f0"] + intervals[i]),
            "volume": -10            
        })
      var osc = new Tone.Oscillator(spec_dict).connect(ampEnv).start();
    }
  
    ampEnv.triggerAttackRelease((chord["attack"] + chord["decay"])*(1+reg))
  
}
  
util_freq2midi = function (freq) {
    return Math.log2(freq/440)*12 + 69
}

util_midi2freq = function (midi) {
    return (Math.pow(2,(midi-69)/12))*440
}

util_complex = function (NH) {
    var partials = []
    var norm = 0

    for (i=1;i<=NH;i++){
        weight = - Math.log2(i) * 12
        weight = Math.pow(10,weight/20) // decays at the rate of 12 dB/octave
        partials = partials.concat([weight])
        norm = norm + Math.pow(weight,2)
    }

    return partials.map(x => x/Math.sqrt(norm))

}

play_2afc = function(chordA,chordB) {
    play_chord(chordA)
    setTimeout(function() {
      play_chord(chordB)
      }, 2000)
}

play_list = function(chords) {
    var n = chords.length;
    var onsets = new Array(n).fill(0);
    
    for (i = 0; i < n; i ++) {
      chord = chords[i];
      if (i < n - 1) {
        onsets[i + 1] = onsets[i] + 2;
      }
      play_chord_with_delay(chord, 1000 * onsets[i]);
    }
  };
  
play_chord_with_delay = function(chord, delay) {
setTimeout(function() {
    play_chord(chord);
}, delay);
};